unit Question2_u;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls;

type
  TfrmQuestion2 = class(TForm)
    Panel1: TPanel;
    btnSalesInformation: TButton;
    btnUnderperforming: TButton;
    btnNewWeek: TButton;
    redOutput: TRichEdit;
    procedure btnSalesInformationClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btnUnderperformingClick(Sender: TObject);
    procedure btnNewWeekClick(Sender: TObject);
  private
    { Private declarations }
    function AvgForWeekX(WeekNr: Integer): Real;
    procedure WriteToFile(iWeekNumber: integer);
  public
    { Public declarations }
  end;

var
  frmQuestion2: TfrmQuestion2;

implementation
//Provided code
var
 aDepartments : array[1..8] of String = (
  'PCs &Laptops', 'Tablets & eReaders', 'Software',
  'Printers, Toners and Ink', 'Cellphones', 'Games & Drones ',
  'Network equipment', 'Accessories');

 aSales: array [1..8, 1..6] of Real = (
  (935.89, 965.99, 4056.77,5023.89, 3802.66, 1146.98),
  (2667.78, 2491.78, 1989.65, 2647.88,1601.56, 1921.99),
  (6702.45, 4271.56, 3424.45, 3924.55, 3085.45,3359.77),
  (6662.34, 6658.45, 8075.43, 2360.66, 2635.44, 7365.69),
  (16405.33, 9741.37, 13381.56, 18969.76, 8604.55, 20207.56),
  (10515.29, 7582.66, 9856.56, 7537.68, 9115.67, 8401.55),
  (7590.99, 9212.65, 9070.98, 6439.99, 7984.88, 8767.45),
  (9220.65, 8097.99, 10067.44, 9960.87, 10109.56, 6571.66));

 iStartWeek: Integer = 1;
{$R *.dfm}

function TfrmQuestion2.AvgForWeekX(WeekNr: Integer): Real;
var
iRow: Integer;
rSum, rAvg: Real;
begin
     rSum := 0;
     for iRow := 1 to Length(aDepartments) do
         rSum := rSum + aSales[iRow, WeekNr];
     rAvg := rSum / Length(aDepartments);
     Result := rAvg;
end;

procedure TfrmQuestion2.btnNewWeekClick(Sender: TObject);
var
   i, iRow, iCol: Integer;
   sLine: String;
begin
     WriteToFile(iStartWeek);
     Inc(iStartWeek);
     for iRow := 1 to Length(aDepartments) do
         for iCol := 1 to 5 do
             aSales[iRow, iCol] := aSales[iRow, iCol + 1];
             for iRow := 1 to Length(aDepartments) do
                 aSales[iRow, 6] := random(4501) + 500 + random;
     redOutput.Clear;
     sLine := 'Department' + #9;
     for i := iStartWeek to iStartWeek + 5 do
      sLine := sLine + 'Week ' + IntToStr(i) + #9;
      redOutput.Lines.Add(sLine);
      for iRow := 1 to Length(aDepartments) do
      begin
           sLine := aDepartments[iRow] + #9;
           for iCol := 1 to 6 do
           begin
           sLine := sLine + FloatToStrF(aSales[iRow, iCol], ffCurrency, 8, 2) + #9;
           end;
           redOutput.Lines.Add(sLine);
      end;
end;

procedure TfrmQuestion2.btnSalesInformationClick(Sender: TObject);
var
 i, iRow, iCol : Integer;
 sLine : String;
begin
  sLine := 'Department' + #9;
  for i := iStartWeek to iStartWeek + 5 do
      sLine := sLine + 'Week ' + IntToStr(i) + #9;
      redOutput.Lines.Add(sLine);
      for iRow := 1 to Length(aDepartments) do
      begin
           sLine := aDepartments[iRow] + #9;
           for iCol := 1 to 6 do
           begin
           sLine := sLine + FloatToStrF(aSales[iRow, iCol], ffCurrency, 8, 2) + #9;
           end;
           redOutput.Lines.Add(sLine);
      end;
end;

procedure TfrmQuestion2.btnUnderperformingClick(Sender: TObject);
var
   iRow, iCol, iCountWeek : Integer;
   rAvg : Real;
begin
     redOutput.Clear;
     redOutput.Lines.Add('Underperforming departments per week:');
     for iCol := 1 to 6 do
     begin
          rAvg := AvgForWeekX(iCol);
          redOutput.Lines.Add('Week ' + IntToStr(iCol) + ': ' + 'Avg sales: ' + FloatToStrF(rAvg, ffCurrency, 8, 2));
          for iRow := 1 to Length(aDepartments) do
          begin
          if aSales[iRow, iCol] < rAvg then
          begin
               redOutput.Lines.Add(aDepartments[iRow] + #9 +  FloatToStrF(aSales[iRow, iCol], ffCurrency, 8, 2));
               end;
          end; // for iRow
          redOutput.Lines.Add(' ');
     end;
end;

procedure TfrmQuestion2.FormActivate(Sender: TObject);
begin
redOutput.Paragraph.TabCount := 6;
redOutput.Paragraph.Tab[0] := 150;
redOutput.Paragraph.Tab[1] := 230;
redOutput.Paragraph.Tab[2] := 310;
redOutput.Paragraph.Tab[3] := 390;
redOutput.Paragraph.Tab[4] := 470;
redOutput.Paragraph.Tab[5] := 550;
end;

procedure TfrmQuestion2.WriteToFile(iWeekNumber: integer);
var
   tFile: TextFile;
   iRow : Integer;
begin
     AssignFile(tFile, 'Week ' + IntToStr(iWeekNumber) + '.txt');
     Rewrite(tFile);
     for iRow := 1 to Length(aDepartments) do
         Writeln(tFile, aDepartments[iRow]+':'+ FloatToStrF(aSales[iRow, 1],ffCurrency, 6, 2));
         CloseFile(tFile);
end;

end.
